﻿/*
CREATES:
	EV terrainChange
	() runFunc
	
REQUIRES:
	eventSystem.as
	sendEvent.as
	"onTileChange" event
*/


function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()


terrainChange_obj = runFunc(function(){
	var xTile = Math.floor(_x/mapTileSize);
	var yTile = Math.floor(_y/mapTileSize);
	//var lastTerrain = MAP.collision_array[xTile][yTile];
	var lastTerrain = -1;		// assume you're starting on ???, so that other terrains will trigger a transition
	
	function onTileChange( evt ){
		var xTile = evt.currentTile.x;
		var yTile = evt.currentTile.y;
		var terrain = MAP.collision_array[xTile][yTile];
		if(terrain !== lastTerrain)
		{// if:  this sprite has stepped onto different terrain
			sendEvent("terrainChange", {
				oldTerrain: lastTerrain,
				newTerrain: terrain
			});
		}// if:  this sprite has stepped onto different terrain
		lastTerrain = terrain;
	}// onTileChange()
	
	react.to("onTileChange").then = onTileChange;
});// onTileChange_obj
